DROP VIEW EEUSR.WKF_ISSUE_TYPE;

/* Formatted on 10/20/2015 1:49:31 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.WKF_ISSUE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_WKFIssueType STDG, STD_WKFIssueTypeHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_WKFIssueType STDG, STD_WKFIssueTypeHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM WKF_ISSUE_TYPE FOR EEUSR.WKF_ISSUE_TYPE;


GRANT SELECT ON EEUSR.WKF_ISSUE_TYPE TO EE_V_R;
DROP VIEW EEUSR.WKF_CASE_TYPE;

/* Formatted on 10/20/2015 1:49:34 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.WKF_CASE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_WORKFLOWCASETYPE STDG, STD_WKFLOCASETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_WORKFLOWCASETYPE STDG,
                         STD_WKFLOCASETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_TYPE FOR EEUSR.WKF_CASE_TYPE;


GRANT SELECT ON EEUSR.WKF_CASE_TYPE TO EE_V_R;
DROP VIEW EEUSR.WKF_CASE_STATUS_TYPE;

/* Formatted on 10/20/2015 1:49:37 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.WKF_CASE_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_WORKFLOWCASESTATUS STDG, STD_WKFLOCASESTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_WORKFLOWCASESTATUS STDG,
                         STD_WKFLOCASESTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_STATUS_TYPE FOR EEUSR.WKF_CASE_STATUS_TYPE;


GRANT SELECT ON EEUSR.WKF_CASE_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.WKF_CASE_REQUEST_TYPE;

/* Formatted on 10/20/2015 1:49:40 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.WKF_CASE_REQUEST_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_WORKFLOWCASEREQUEST STDG, STD_WKFLOCASEREQUESTHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_WORKFLOWCASEREQUEST STDG,
                         STD_WKFLOCASEREQUESTHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_REQUEST_TYPE FOR EEUSR.WKF_CASE_REQUEST_TYPE;


GRANT SELECT ON EEUSR.WKF_CASE_REQUEST_TYPE TO EE_V_R;
DROP VIEW EEUSR.WKF_CASE_ACTIVITY_TYPE;

/* Formatted on 10/20/2015 1:49:44 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.WKF_CASE_ACTIVITY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_WORKFLOWCASEACTIVITY STDG, STD_WKFLOCASEACTIVITYHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_WORKFLOWCASEACTIVITY STDG,
                         STD_WKFLOCASEACTIVITYHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM WKF_CASE_ACTIVITY_TYPE FOR EEUSR.WKF_CASE_ACTIVITY_TYPE;


GRANT SELECT ON EEUSR.WKF_CASE_ACTIVITY_TYPE TO EE_V_R;
DROP VIEW EEUSR.VBA_QUERY_STATUS_TYPE;

/* Formatted on 10/20/2015 1:49:48 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.VBA_QUERY_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_VBAQUERYSTATUSTYPE STDG, STD_VBAQUERYSTATUSTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_VBAQUERYSTATUSTYPE STDG,
                         STD_VBAQUERYSTATUSTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM VBA_QUERY_STATUS_TYPE FOR EEUSR.VBA_QUERY_STATUS_TYPE;


GRANT SELECT ON EEUSR.VBA_QUERY_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.USER_GROUP_TYPE;

/* Formatted on 10/20/2015 1:49:51 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.USER_GROUP_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_UserGroupType STDG, STD_UserGroupTypeHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_UserGroupType STDG,
                         STD_UserGroupTypeHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM USER_GROUP_TYPE FOR EEUSR.USER_GROUP_TYPE;


GRANT SELECT ON EEUSR.USER_GROUP_TYPE TO EE_V_R;
DROP VIEW EEUSR.SSN_VRFN_STATUS_TYPE;

/* Formatted on 10/20/2015 1:49:54 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SSN_VRFN_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SSNVERIFICATIONSTATUS STDG, STD_SSNVERIFSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SSNVERIFICATIONSTATUS STDG,
                         STD_SSNVERIFSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SSN_VRFN_STATUS_TYPE FOR EEUSR.SSN_VRFN_STATUS_TYPE;


GRANT SELECT ON EEUSR.SSN_VRFN_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.SSN_CHANGE_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:49:57 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SSN_CHANGE_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SSNCHANGESOURCE STDG, STD_SSNCHANGESOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SSNCHANGESOURCE STDG,
                         STD_SSNCHANGESOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SSN_CHANGE_SOURCE_TYPE FOR EEUSR.SSN_CHANGE_SOURCE_TYPE;


GRANT SELECT ON EEUSR.SSN_CHANGE_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.SSA_MESSAGE_TYPE;

/* Formatted on 10/20/2015 1:50:00 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SSA_MESSAGE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SSAVERIFCODE STDG, STD_SSAVERIFCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SSAVERIFCODE STDG, STD_SSAVERIFCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SSA_MESSAGE_TYPE FOR EEUSR.SSA_MESSAGE_TYPE;


GRANT SELECT ON EEUSR.SSA_MESSAGE_TYPE TO EE_V_R;
DROP VIEW EEUSR.SPCL_FACTOR_MAPPING_TYPE;

/* Formatted on 10/20/2015 1:50:03 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SPCL_FACTOR_MAPPING_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SPECIALFACTORMAP STDG, STD_SPECIALFACTORMAPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SPECIALFACTORMAP STDG,
                         STD_SPECIALFACTORMAPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SPCL_FACTOR_MAPPING_TYPE FOR EEUSR.SPCL_FACTOR_MAPPING_TYPE;


GRANT SELECT ON EEUSR.SPCL_FACTOR_MAPPING_TYPE TO EE_V_R;
DROP VIEW EEUSR.SITE_UPLOAD_STATUS_TYPE;

/* Formatted on 10/20/2015 1:50:07 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SITE_UPLOAD_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SITEUPLOADSTATUS STDG, STD_SITEUPLOADSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SITEUPLOADSTATUS STDG,
                         STD_SITEUPLOADSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SITE_UPLOAD_STATUS_TYPE FOR EEUSR.SITE_UPLOAD_STATUS_TYPE;


GRANT SELECT ON EEUSR.SITE_UPLOAD_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.SITE_NO_UPLOAD_REASON_TYPE;

/* Formatted on 10/20/2015 1:50:10 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SITE_NO_UPLOAD_REASON_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NOSITEUPLOADREASON STDG, STD_NOSITEUPLOADREASONHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NOSITEUPLOADREASON STDG,
                         STD_NOSITEUPLOADREASONHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SITE_NO_UPLOAD_REASON_TYPE FOR EEUSR.SITE_NO_UPLOAD_REASON_TYPE;


GRANT SELECT ON EEUSR.SITE_NO_UPLOAD_REASON_TYPE TO EE_V_R;
DROP VIEW EEUSR.SIGNATURE_INDICATOR_TYPE;

/* Formatted on 10/20/2015 1:50:13 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SIGNATURE_INDICATOR_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SignatureIndType STDG, STD_SignatureIndTypeHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SignatureIndType STDG,
                         STD_SignatureIndTypeHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SIGNATURE_INDICATOR_TYPE FOR EEUSR.SIGNATURE_INDICATOR_TYPE;


GRANT SELECT ON EEUSR.SIGNATURE_INDICATOR_TYPE TO EE_V_R;
DROP VIEW EEUSR.SHAD_DOCUMENT_TYPE;

/* Formatted on 10/20/2015 1:50:16 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SHAD_DOCUMENT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SHADDOCUMENTTYPE STDG, STD_SHADDOCUMENTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SHADDOCUMENTTYPE STDG,
                         STD_SHADDOCUMENTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SHAD_DOCUMENT_TYPE FOR EEUSR.SHAD_DOCUMENT_TYPE;


GRANT SELECT ON EEUSR.SHAD_DOCUMENT_TYPE TO EE_V_R;
DROP VIEW EEUSR.SERVICE_DISCHARGE_TYPE;

/* Formatted on 10/20/2015 1:50:19 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SERVICE_DISCHARGE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SERVICEDISCHARGECODE STDG, STD_SVCDSCHRGCDHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SERVICEDISCHARGECODE STDG,
                         STD_SVCDSCHRGCDHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SERVICE_DISCHARGE_TYPE FOR EEUSR.SERVICE_DISCHARGE_TYPE;


GRANT SELECT ON EEUSR.SERVICE_DISCHARGE_TYPE TO EE_V_R;
DROP VIEW EEUSR.SERVICE_BRANCH_TYPE;

/* Formatted on 10/20/2015 1:50:24 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SERVICE_BRANCH_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SERVICEBRANCH STDG, STD_SERVICEBRANCHHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SERVICEBRANCH STDG,
                         STD_SERVICEBRANCHHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SERVICE_BRANCH_TYPE FOR EEUSR.SERVICE_BRANCH_TYPE;


GRANT SELECT ON EEUSR.SERVICE_BRANCH_TYPE TO EE_V_R;
DROP VIEW EEUSR.SENSITIVITY_CHG_SRC_TYPE;

/* Formatted on 10/20/2015 1:50:26 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.SENSITIVITY_CHG_SRC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_SENSITIVITYCHANGESOURCE STDG,
          STD_SENSITIVITYCHNGSRCHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_SENSITIVITYCHANGESOURCE STDG,
                         STD_SENSITIVITYCHNGSRCHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM SENSITIVITY_CHG_SRC_TYPE FOR EEUSR.SENSITIVITY_CHG_SRC_TYPE;


GRANT SELECT ON EEUSR.SENSITIVITY_CHG_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_WORK_ITEM_STATUS_TYPE;

/* Formatted on 10/20/2015 1:50:30 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_WORK_ITEM_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTWorkItemStType STDG, STD_RPTWorkItemStTypeHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTWorkItemStType STDG,
                         STD_RPTWorkItemStTypeHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_WORK_ITEM_STATUS_TYPE FOR EEUSR.RPT_WORK_ITEM_STATUS_TYPE;


GRANT SELECT ON EEUSR.RPT_WORK_ITEM_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_WEEK_OF_MONTH_TYPE;

/* Formatted on 10/20/2015 1:50:33 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_WEEK_OF_MONTH_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTWEEKOFMONTHTYPE STDG, STD_RPTWEEKOFMONTHTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTWEEKOFMONTHTYPE STDG,
                         STD_RPTWEEKOFMONTHTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_WEEK_OF_MONTH_TYPE FOR EEUSR.RPT_WEEK_OF_MONTH_TYPE;


GRANT SELECT ON EEUSR.RPT_WEEK_OF_MONTH_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_TYPE;

/* Formatted on 10/20/2015 1:50:37 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_REPORTTYPE STDG, STD_REPORTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_REPORTTYPE STDG, STD_REPORTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_TYPE FOR EEUSR.RPT_TYPE;


GRANT SELECT ON EEUSR.RPT_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_STANDARD_REPORTS;

/* Formatted on 10/20/2015 1:50:40 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_STANDARD_REPORTS
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   TYPEID,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.TYPE_ID AS TYPEID,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTSTANDARDREPORTS STDG, STD_RPTSTANDARDREPORTSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTSTANDARDREPORTS STDG,
                         STD_RPTSTANDARDREPORTSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_STANDARD_REPORTS FOR EEUSR.RPT_STANDARD_REPORTS;


GRANT SELECT ON EEUSR.RPT_STANDARD_REPORTS TO EE_V_R;
DROP VIEW EEUSR.RPT_SITE_DISPLAY_TYPE;

/* Formatted on 10/20/2015 1:50:43 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_SITE_DISPLAY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTSITEDISPLAYTYPE STDG, STD_RPTSITEDISPLAYTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTSITEDISPLAYTYPE STDG,
                         STD_RPTSITEDISPLAYTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_SITE_DISPLAY_TYPE FOR EEUSR.RPT_SITE_DISPLAY_TYPE;


GRANT SELECT ON EEUSR.RPT_SITE_DISPLAY_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_SCHEDULE_TYPE;

/* Formatted on 10/20/2015 1:50:47 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_SCHEDULE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTSCHEDULETYPE STDG, STD_RPTSCHEDULETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTSCHEDULETYPE STDG,
                         STD_RPTSCHEDULETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_SCHEDULE_TYPE FOR EEUSR.RPT_SCHEDULE_TYPE;


GRANT SELECT ON EEUSR.RPT_SCHEDULE_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_RUN_FREQUENCY_TYPE;

/* Formatted on 10/20/2015 1:50:50 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_RUN_FREQUENCY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTRUNFREQUENCYTYP STDG, STD_RPTRUNFREQUENCYTYPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTRUNFREQUENCYTYP STDG,
                         STD_RPTRUNFREQUENCYTYPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_RUN_FREQUENCY_TYPE FOR EEUSR.RPT_RUN_FREQUENCY_TYPE;


GRANT SELECT ON EEUSR.RPT_RUN_FREQUENCY_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_QUARTER_LIST_TYPE;

/* Formatted on 10/20/2015 1:50:53 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_QUARTER_LIST_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTQUARTERLIST STDG, STD_RPTQUARTERLISTHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTQUARTERLIST STDG,
                         STD_RPTQUARTERLISTHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_QUARTER_LIST_TYPE FOR EEUSR.RPT_QUARTER_LIST_TYPE;


GRANT SELECT ON EEUSR.RPT_QUARTER_LIST_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_PERIOD_TYPE;

/* Formatted on 10/20/2015 1:50:57 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_PERIOD_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTPERIODTYPE STDG, STD_RPTPERIODTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTPERIODTYPE STDG,
                         STD_RPTPERIODTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_PERIOD_TYPE FOR EEUSR.RPT_PERIOD_TYPE;


GRANT SELECT ON EEUSR.RPT_PERIOD_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_OUTPUT_FORMAT_TYPE;

/* Formatted on 10/20/2015 1:51:00 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_OUTPUT_FORMAT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTOUTFORMATTYPE STDG, STD_RPTOUTFORMATTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTOUTFORMATTYPE STDG,
                         STD_RPTOUTFORMATTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_OUTPUT_FORMAT_TYPE FOR EEUSR.RPT_OUTPUT_FORMAT_TYPE;


GRANT SELECT ON EEUSR.RPT_OUTPUT_FORMAT_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_OUTPUT_FILE_TYPE;

/* Formatted on 10/20/2015 1:51:03 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_OUTPUT_FILE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTOUTPUTFILETYPE STDG, STD_RPTOUTPUTFILETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTOUTPUTFILETYPE STDG,
                         STD_RPTOUTPUTFILETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_OUTPUT_FILE_TYPE FOR EEUSR.RPT_OUTPUT_FILE_TYPE;


GRANT SELECT ON EEUSR.RPT_OUTPUT_FILE_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_MONTH_LIST_TYPE;

/* Formatted on 10/20/2015 1:51:06 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_MONTH_LIST_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTMONTHLIST STDG, STD_RPTMONTHLISTHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTMONTHLIST STDG, STD_RPTMONTHLISTHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_MONTH_LIST_TYPE FOR EEUSR.RPT_MONTH_LIST_TYPE;


GRANT SELECT ON EEUSR.RPT_MONTH_LIST_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_LETTER_FILE_TYPE;

/* Formatted on 10/20/2015 1:51:09 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_LETTER_FILE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTLETTERFILETYPE STDG, STD_RPTLETTERFILETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTLETTERFILETYPE STDG,
                         STD_RPTLETTERFILETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_LETTER_FILE_TYPE FOR EEUSR.RPT_LETTER_FILE_TYPE;


GRANT SELECT ON EEUSR.RPT_LETTER_FILE_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_EXCEPTION_TYPE;

/* Formatted on 10/20/2015 1:51:13 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_EXCEPTION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTEXCEPTIONTYPE STDG, STD_RPTEXCEPTIONTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTEXCEPTIONTYPE STDG,
                         STD_RPTEXCEPTIONTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_EXCEPTION_TYPE FOR EEUSR.RPT_EXCEPTION_TYPE;


GRANT SELECT ON EEUSR.RPT_EXCEPTION_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_EED_WEEKLY_TYPE;

/* Formatted on 10/20/2015 1:51:15 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_EED_WEEKLY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTEEDWEEKLYTYPE STDG, STD_RPTEEDWEEKLYTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTEEDWEEKLYTYPE STDG,
                         STD_RPTEEDWEEKLYTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_EED_WEEKLY_TYPE FOR EEUSR.RPT_EED_WEEKLY_TYPE;


GRANT SELECT ON EEUSR.RPT_EED_WEEKLY_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DIVISION_TYPE;

/* Formatted on 10/20/2015 1:51:18 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DIVISION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDivisionType STDG, STD_RPTDivisionTypeHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDivisionType STDG,
                         STD_RPTDivisionTypeHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DIVISION_TYPE FOR EEUSR.RPT_DIVISION_TYPE;


GRANT SELECT ON EEUSR.RPT_DIVISION_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DETAIL_FOR_TYPE;

/* Formatted on 10/20/2015 1:51:22 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DETAIL_FOR_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDETAILFORTYPE STDG, STD_RPTDETAILFORTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDETAILFORTYPE STDG,
                         STD_RPTDETAILFORTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DETAIL_FOR_TYPE FOR EEUSR.RPT_DETAIL_FOR_TYPE;


GRANT SELECT ON EEUSR.RPT_DETAIL_FOR_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DETAIL_BY_TYPE;

/* Formatted on 10/20/2015 1:51:25 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DETAIL_BY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDETAILBYTYPE STDG, STD_RPTDETAILBYTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDETAILBYTYPE STDG,
                         STD_RPTDETAILBYTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DETAIL_BY_TYPE FOR EEUSR.RPT_DETAIL_BY_TYPE;


GRANT SELECT ON EEUSR.RPT_DETAIL_BY_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DAY_OF_WEEK_TYPE;

/* Formatted on 10/20/2015 1:51:28 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DAY_OF_WEEK_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDAYOFWEEKTYPE STDG, STD_RPTDAYOFWEEKTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDAYOFWEEKTYPE STDG,
                         STD_RPTDAYOFWEEKTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DAY_OF_WEEK_TYPE FOR EEUSR.RPT_DAY_OF_WEEK_TYPE;


GRANT SELECT ON EEUSR.RPT_DAY_OF_WEEK_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DAY_OF_QUARTER_TYPE;

/* Formatted on 10/20/2015 1:51:31 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DAY_OF_QUARTER_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDAYOFQUARTERTYP STDG, STD_RPTDAYOFQUARTERTYPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDAYOFQUARTERTYP STDG,
                         STD_RPTDAYOFQUARTERTYPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DAY_OF_QUARTER_TYPE FOR EEUSR.RPT_DAY_OF_QUARTER_TYPE;


GRANT SELECT ON EEUSR.RPT_DAY_OF_QUARTER_TYPE TO EE_V_R;
DROP VIEW EEUSR.RPT_DAY_OF_MONTH_TYPE;

/* Formatted on 10/20/2015 1:51:34 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RPT_DAY_OF_MONTH_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RPTDAYOFMONTHTYPE STDG, STD_RPTDAYOFMONTHTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RPTDAYOFMONTHTYPE STDG,
                         STD_RPTDAYOFMONTHTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RPT_DAY_OF_MONTH_TYPE FOR EEUSR.RPT_DAY_OF_MONTH_TYPE;


GRANT SELECT ON EEUSR.RPT_DAY_OF_MONTH_TYPE TO EE_V_R;
DROP VIEW EEUSR.REGISTRY_TYPE;

/* Formatted on 10/20/2015 1:51:37 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.REGISTRY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_REGISTRYTYPE STDG, STD_REGISTRYTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_REGISTRYTYPE STDG, STD_REGISTRYTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM REGISTRY_TYPE FOR EEUSR.REGISTRY_TYPE;


GRANT SELECT ON EEUSR.REGISTRY_TYPE TO EE_V_R;
DROP VIEW EEUSR.RADIATION_EXP_METHOD_TYPE;

/* Formatted on 10/20/2015 1:51:40 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.RADIATION_EXP_METHOD_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RADIATIONEXPOSUREMETHOD STDG, STD_RADIATNEXPSRMTHDHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RADIATIONEXPOSUREMETHOD STDG,
                         STD_RADIATNEXPSRMTHDHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM RADIATION_EXP_METHOD_TYPE FOR EEUSR.RADIATION_EXP_METHOD_TYPE;


GRANT SELECT ON EEUSR.RADIATION_EXP_METHOD_TYPE TO EE_V_R;
DROP VIEW EEUSR.PSEUDO_SSN_REASON_TYPE;

/* Formatted on 10/20/2015 1:51:43 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PSEUDO_SSN_REASON_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PSEUDOSSNREASON STDG, STD_PSEUDOSSNREASONHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PSEUDOSSNREASON STDG,
                         STD_PSEUDOSSNREASONHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PSEUDO_SSN_REASON_TYPE FOR EEUSR.PSEUDO_SSN_REASON_TYPE;


GRANT SELECT ON EEUSR.PSEUDO_SSN_REASON_TYPE TO EE_V_R;
DROP VIEW EEUSR.PRSN_RELATION_MAPPING_TYPE;

/* Formatted on 10/20/2015 1:51:47 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PRSN_RELATION_MAPPING_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PERSONRELATION STDG, STD_PERSONRELATIONHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PERSONRELATION STDG,
                         STD_PERSONRELATIONHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PRSN_RELATION_MAPPING_TYPE FOR EEUSR.PRSN_RELATION_MAPPING_TYPE;


GRANT SELECT ON EEUSR.PRSN_RELATION_MAPPING_TYPE TO EE_V_R;
DROP VIEW EEUSR.PROCEDURE_TYPE;

/* Formatted on 10/20/2015 1:51:50 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PROCEDURE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE,
   CODESET_TYPE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE,
          STDG.CODESET_TYPE
     FROM STD_PROCEDURECODE STDG, STD_PROCEDURECODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PROCEDURECODE STDG,
                         STD_PROCEDURECODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PROCEDURE_TYPE FOR EEUSR.PROCEDURE_TYPE;


GRANT SELECT ON EEUSR.PROCEDURE_TYPE TO EE_V_R;
DROP VIEW EEUSR.PRIORITY_SUB_GROUP_TYPE;

/* Formatted on 10/20/2015 1:51:53 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PRIORITY_SUB_GROUP_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ENROLLMENTPRIORSGRP STDG, STD_ENROLLMENTPRIORSGRPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ENROLLMENTPRIORSGRP STDG,
                         STD_ENROLLMENTPRIORSGRPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PRIORITY_SUB_GROUP_TYPE FOR EEUSR.PRIORITY_SUB_GROUP_TYPE;


GRANT SELECT ON EEUSR.PRIORITY_SUB_GROUP_TYPE TO EE_V_R;
DROP VIEW EEUSR.PRIORITY_GROUP_TYPE;

/* Formatted on 10/20/2015 1:51:56 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PRIORITY_GROUP_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ENROLLMENTPRIORGRP STDG, STD_ENROLLMENTPRIORGRPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ENROLLMENTPRIORGRP STDG,
                         STD_ENROLLMENTPRIORGRPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PRIORITY_GROUP_TYPE FOR EEUSR.PRIORITY_GROUP_TYPE;


GRANT SELECT ON EEUSR.PRIORITY_GROUP_TYPE TO EE_V_R;
DROP VIEW EEUSR.POW_DOCUMENT_TYPE;

/* Formatted on 10/20/2015 1:51:59 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.POW_DOCUMENT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_POWDOCUMENTTYPE STDG, STD_POWDOCUMENTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_POWDOCUMENTTYPE STDG,
                         STD_POWDOCUMENTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM POW_DOCUMENT_TYPE FOR EEUSR.POW_DOCUMENT_TYPE;


GRANT SELECT ON EEUSR.POW_DOCUMENT_TYPE TO EE_V_R;
DROP VIEW EEUSR.POW_DATA_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:52:03 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.POW_DATA_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_POWDATASOURCETYPE STDG, STD_POWDATASOURCETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_POWDATASOURCETYPE STDG,
                         STD_POWDATASOURCETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM POW_DATA_SOURCE_TYPE FOR EEUSR.POW_DATA_SOURCE_TYPE;


GRANT SELECT ON EEUSR.POW_DATA_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.POW_CONFINE_LOCN_TYPE;

/* Formatted on 10/20/2015 1:52:05 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.POW_CONFINE_LOCN_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.ALTERNATENAME AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_POWPERIOD STDG, STD_POWPERIODhistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_POWPERIOD STDG, STD_POWPERIODHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM POW_CONFINE_LOCN_TYPE FOR EEUSR.POW_CONFINE_LOCN_TYPE;


GRANT SELECT ON EEUSR.POW_CONFINE_LOCN_TYPE TO EE_V_R;
DROP VIEW EEUSR.POLICY_HOLDER_TYPE;

/* Formatted on 10/20/2015 1:52:09 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.POLICY_HOLDER_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INSURANCEHOLDERTYPE STDG, STD_INSURANCEHOLDERTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INSURANCEHOLDERTYPE STDG,
                         STD_INSURANCEHOLDERTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM POLICY_HOLDER_TYPE FOR EEUSR.POLICY_HOLDER_TYPE;


GRANT SELECT ON EEUSR.POLICY_HOLDER_TYPE TO EE_V_R;
DROP VIEW EEUSR.PH_STATUS_TYPE;

/* Formatted on 10/20/2015 1:52:12 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PH_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_DECORATIONSTATUS STDG, STD_DECORATIONSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_DECORATIONSTATUS STDG,
                         STD_DECORATIONSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PH_STATUS_TYPE FOR EEUSR.PH_STATUS_TYPE;


GRANT SELECT ON EEUSR.PH_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.PH_DOCUMENT_TYPE;

/* Formatted on 10/20/2015 1:52:15 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PH_DOCUMENT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_DECORATIONDOCUMENTTYPE STDG, STD_DECORATNDOCTYPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_DECORATIONDOCUMENTTYPE STDG,
                         STD_DECORATNDOCTYPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PH_DOCUMENT_TYPE FOR EEUSR.PH_DOCUMENT_TYPE;


GRANT SELECT ON EEUSR.PH_DOCUMENT_TYPE TO EE_V_R;
DROP VIEW EEUSR.PH_DATA_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:52:19 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PH_DATA_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PHDATASRCTYPE STDG, STD_PHDATASRCTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PHDATASRCTYPE STDG,
                         STD_PHDATASRCTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PH_DATA_SOURCE_TYPE FOR EEUSR.PH_DATA_SOURCE_TYPE;


GRANT SELECT ON EEUSR.PH_DATA_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.PHONE_TYPE;

/* Formatted on 10/20/2015 1:52:22 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PHONE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PHONECONTACTTYPE STDG, STD_PHONECONTACTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PHONECONTACTTYPE STDG,
                         STD_PHONECONTACTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PHONE_TYPE FOR EEUSR.PHONE_TYPE;


GRANT SELECT ON EEUSR.PHONE_TYPE TO EE_V_R;
DROP VIEW EEUSR.PHONE_CHANGE_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:52:26 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PHONE_CHANGE_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PHONECHANGESOURCE STDG, STD_PHONECHANGESOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PHONECHANGESOURCE STDG,
                         STD_PHONECHANGESOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PHONE_CHANGE_SOURCE_TYPE FOR EEUSR.PHONE_CHANGE_SOURCE_TYPE;


GRANT SELECT ON EEUSR.PHONE_CHANGE_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.PERSON_RELATION_TYPE;

/* Formatted on 10/20/2015 1:52:28 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PERSON_RELATION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_RELATIONSHIP STDG, STD_RELATIONSHIPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_RELATIONSHIP STDG, STD_RELATIONSHIPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PERSON_RELATION_TYPE FOR EEUSR.PERSON_RELATION_TYPE;


GRANT SELECT ON EEUSR.PERSON_RELATION_TYPE TO EE_V_R;
DROP VIEW EEUSR.PERSON_CONTACT_TYPE;

/* Formatted on 10/20/2015 1:52:32 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PERSON_CONTACT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PERSONCONTACTTYPE STDG, STD_PERSONCONTACTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PERSONCONTACTTYPE STDG,
                         STD_PERSONCONTACTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PERSON_CONTACT_TYPE FOR EEUSR.PERSON_CONTACT_TYPE;


GRANT SELECT ON EEUSR.PERSON_CONTACT_TYPE TO EE_V_R;
DROP VIEW EEUSR.PERMISSION_TYPE;

/* Formatted on 10/20/2015 1:52:35 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.PERMISSION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_PERMISSIONTYPE STDG, STD_PERMISSIONTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_PERMISSIONTYPE STDG,
                         STD_PERMISSIONTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM PERMISSION_TYPE FOR EEUSR.PERMISSION_TYPE;


GRANT SELECT ON EEUSR.PERMISSION_TYPE TO EE_V_R;
DROP VIEW EEUSR.NTR_VERIFY_METHOD_TYPE;

/* Formatted on 10/20/2015 1:52:38 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.NTR_VERIFY_METHOD_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NTRVERIFICATIONMETHOD STDG, STD_NTRVERIFICATNMTHDHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NTRVERIFICATIONMETHOD STDG,
                         STD_NTRVERIFICATNMTHDHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM NTR_VERIFY_METHOD_TYPE FOR EEUSR.NTR_VERIFY_METHOD_TYPE;


GRANT SELECT ON EEUSR.NTR_VERIFY_METHOD_TYPE TO EE_V_R;
DROP VIEW EEUSR.NCOA_ZIP_NO_MATCH_TYPE;

/* Formatted on 10/20/2015 1:52:40 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.NCOA_ZIP_NO_MATCH_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NCOAZIPNOMATCHTYPE STDG, STD_NCOAZIPNOMATCHTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NCOAZIPNOMATCHTYPE STDG,
                         STD_NCOAZIPNOMATCHTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM NCOA_ZIP_NO_MATCH_TYPE FOR EEUSR.NCOA_ZIP_NO_MATCH_TYPE;


GRANT SELECT ON EEUSR.NCOA_ZIP_NO_MATCH_TYPE TO EE_V_R;
DROP VIEW EEUSR.NCOA_ZIP_MATCH_TYPE;

/* Formatted on 10/20/2015 1:52:43 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.NCOA_ZIP_MATCH_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NCOAZIPMATCHTYPE STDG, STD_NCOAZIPMATCHTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NCOAZIPMATCHTYPE STDG,
                         STD_NCOAZIPMATCHTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM NCOA_ZIP_MATCH_TYPE FOR EEUSR.NCOA_ZIP_MATCH_TYPE;


GRANT SELECT ON EEUSR.NCOA_ZIP_MATCH_TYPE TO EE_V_R;
DROP VIEW EEUSR.NCOA_STATUS_TYPE;

/* Formatted on 10/20/2015 1:52:48 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.NCOA_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NCOASTATUSTYPE STDG, STD_NCOASTATUSTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NCOASTATUSTYPE STDG,
                         STD_NCOASTATUSTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM NCOA_STATUS_TYPE FOR EEUSR.NCOA_STATUS_TYPE;


GRANT SELECT ON EEUSR.NCOA_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.NCOA_DELIVERY_TYPE;

/* Formatted on 10/20/2015 1:52:51 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.NCOA_DELIVERY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_NCOADELIVERYTYPE STDG, STD_NCOADELIVERYTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_NCOADELIVERYTYPE STDG,
                         STD_NCOADELIVERYTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM NCOA_DELIVERY_TYPE FOR EEUSR.NCOA_DELIVERY_TYPE;


GRANT SELECT ON EEUSR.NCOA_DELIVERY_TYPE TO EE_V_R;
DROP VIEW EEUSR.MT_NOT_REQD_RSN_TYPE;

/* Formatted on 10/20/2015 1:52:54 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.MT_NOT_REQD_RSN_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MTNOTREQRSNTYPE STDG, STD_MTNOTREQRSNTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MTNOTREQRSNTYPE STDG,
                         STD_MTNOTREQRSNTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM MT_NOT_REQD_RSN_TYPE FOR EEUSR.MT_NOT_REQD_RSN_TYPE;


GRANT SELECT ON EEUSR.MT_NOT_REQD_RSN_TYPE TO EE_V_R;
DROP VIEW EEUSR.MST_STATUS_TYPE;

/* Formatted on 10/20/2015 1:52:57 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.MST_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MSTSTATUS STDG, STD_MSTSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MSTSTATUS STDG, STD_MSTSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM MST_STATUS_TYPE FOR EEUSR.MST_STATUS_TYPE;


GRANT SELECT ON EEUSR.MST_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.MONETARY_BENEFIT_TYPE;

/* Formatted on 10/20/2015 1:53:01 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.MONETARY_BENEFIT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MONETARYBENEFITTYPE STDG, STD_MONETARYBENEFITTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MONETARYBENEFITTYPE STDG,
                         STD_MONETARYBENEFITTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM MONETARY_BENEFIT_TYPE FOR EEUSR.MONETARY_BENEFIT_TYPE;


GRANT SELECT ON EEUSR.MONETARY_BENEFIT_TYPE TO EE_V_R;
DROP VIEW EEUSR.MESSAGE_TRANSMISSION_TYPE;

/* Formatted on 10/20/2015 1:53:03 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.MESSAGE_TRANSMISSION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   DIRECTION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.DIRECTION AS DIRECTION,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MESSAGETYPE STDG, STD_MESSAGETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MESSAGETYPE STDG, STD_MESSAGETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM MESSAGE_TRANSMISSION_TYPE FOR EEUSR.MESSAGE_TRANSMISSION_TYPE;


GRANT SELECT ON EEUSR.MESSAGE_TRANSMISSION_TYPE TO EE_V_R;
DROP VIEW EEUSR.MEANS_TEST_STATUS_TYPE;

/* Formatted on 10/20/2015 1:53:06 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.MEANS_TEST_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MEANSTESTSTATUS STDG, STD_MEANSTESTSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MEANSTESTSTATUS STDG,
                         STD_MEANSTESTSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM MEANS_TEST_STATUS_TYPE FOR EEUSR.MEANS_TEST_STATUS_TYPE;


GRANT SELECT ON EEUSR.MEANS_TEST_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.LANGUAGE_CODE;

/* Formatted on 10/20/2015 1:53:09 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.LANGUAGE_CODE
(
   ID,
   CODE_1,
   CODE,
   DESCRIPTION,
   NAME,
   SORT_ORDER,
   VERSION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE_1,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.SORT_ORDER AS sort_order,
          STDG.VERSION AS version,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM ADRREF.STD_LANGUAGECODE STDG, ADRREF.STD_LANGUAGECODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM ADRREF.STD_LANGUAGECODE STDG,
                         ADRREF.STD_LANGUAGECODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM LANGUAGE_CODE FOR EEUSR.LANGUAGE_CODE;


GRANT SELECT ON EEUSR.LANGUAGE_CODE TO EE_V_R;
DROP VIEW EEUSR.IVM_MIGRATE_TYPE;

/* Formatted on 10/20/2015 1:53:13 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.IVM_MIGRATE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_IVMMIGRATETYPE STDG, STD_IVMMIGRATETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_IVMMIGRATETYPE STDG,
                         STD_IVMMIGRATETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM IVM_MIGRATE_TYPE FOR EEUSR.IVM_MIGRATE_TYPE;


GRANT SELECT ON EEUSR.IVM_MIGRATE_TYPE TO EE_V_R;
DROP VIEW EEUSR.INSURANCE_RPT_SRC_TYPE;

/* Formatted on 10/20/2015 1:53:16 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INSURANCE_RPT_SRC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INSURANCEREPORTSOURCE STDG, STD_INSRPRTSRCHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INSURANCEREPORTSOURCE STDG,
                         STD_INSRPRTSRCHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INSURANCE_RPT_SRC_TYPE FOR EEUSR.INSURANCE_RPT_SRC_TYPE;


GRANT SELECT ON EEUSR.INSURANCE_RPT_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.INSURANCE_PLAN_TYPE;

/* Formatted on 10/20/2015 1:53:19 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INSURANCE_PLAN_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INSURANCEPLANTYPE STDG, STD_INSPLANTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INSURANCEPLANTYPE STDG,
                         STD_INSPLANTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INSURANCE_PLAN_TYPE FOR EEUSR.INSURANCE_PLAN_TYPE;


GRANT SELECT ON EEUSR.INSURANCE_PLAN_TYPE TO EE_V_R;
DROP VIEW EEUSR.INSURANCE_MAPPING_TYPE;

/* Formatted on 10/20/2015 1:53:24 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INSURANCE_MAPPING_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INSURANCEMAPPING STDG, STD_INSURANCEMAPPINGHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INSURANCEMAPPING STDG,
                         STD_INSURANCEMAPPINGHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INSURANCE_MAPPING_TYPE FOR EEUSR.INSURANCE_MAPPING_TYPE;


GRANT SELECT ON EEUSR.INSURANCE_MAPPING_TYPE TO EE_V_R;
DROP VIEW EEUSR.INCOME_THRESHOLD;

/* Formatted on 10/20/2015 1:53:27 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INCOME_THRESHOLD
(
   ID,
   INCOME_THRESHOLD_YEAR,
   EXEMPT_AMOUNT,
   MEDICAL_EXPENSE_DEDUCTIBLE,
   CHILD_INCOME_EXCLUSION,
   DEPENDENT,
   THRESHOLD_EFFECTIVE_DATE,
   ADD_DEPENDENT_THRESHOLD,
   PROPERTY_THRESHOLD,
   PENSION_THRESHOLD,
   AID_AND_ATTENDANCE_THRESHOLD,
   PENSION_1_DEPENDENT,
   ADD_DEPENDENT_PENSION,
   NINETY_DAY_HOSPITAL_COPAY,
   ADD_90_DAY_HOSPITAL_COPAY,
   OUTPATIENT_BASIC_CARE_COPAY,
   OUTPATIENT_SPECIALTY_COPAY,
   OUTPATIENT_PREVENTIVE_COPAY,
   LTC_INPATIENT_COPAY,
   LTC_OUTPATIENT_COPAY,
   LTC_DOMICILIARY_COPAY,
   INPATIENT_PER_DIEM,
   MEDICATION_COPAY,
   MEDICATION_COPAY_ANNUAL_CAP,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.INCOME_THRESHOLD_YEAR AS INCOME_THRESHOLD_YEAR,
          STDG.EXEMPT_AMOUNT AS EXEMPT_AMOUNT,
          STDG.MEDICAL_EXPENSE_DEDUCTIBLE AS MEDICAL_EXPENSE_DEDUCTIBLE,
          STDG.CHILD_INCOME_EXCLUSION AS CHILD_INCOME_EXCLUSION,
          STDG.DEPENDENT AS DEPENDENT,
          STDG.THRESHOLD_EFFECTIVE_DATE AS THRESHOLD_EFFECTIVE_DATE,
          STDG.ADD_DEPENDENT_THRESHOLD AS ADD_DEPENDENT_THRESHOLD,
          STDG.PROPERTY_THRESHOLD AS PROPERTY_THRESHOLD,
          STDG.PENSION_THRESHOLD AS PENSION_THRESHOLD,
          STDG.AID_AND_ATTENDANCE_THRESHOLD AS AID_AND_ATTENDANCE_THRESHOLD,
          STDG.PENSION_1_DEPENDENT AS PENSION_1_DEPENDENT,
          STDG.ADD_DEPENDENT_PENSION AS ADD_DEPENDENT_PENSION,
          STDG.NINETY_DAY_HOSPITAL_COPAY AS NINETY_DAY_HOSPITAL_COPAY,
          STDG.ADD_90_DAY_HOSPITAL_COPAY AS ADD_90_DAY_HOSPITAL_COPAY,
          STDG.OUTPATIENT_BASIC_CARE_COPAY AS OUTPATIENT_BASIC_CARE_COPAY,
          STDG.OUTPATIENT_SPECIALTY_COPAY AS OUTPATIENT_SPECIALTY_COPAY,
          STDG.OUTPATIENT_PREVENTIVE_COPAY AS OUTPATIENT_PREVENTIVE_COPAY,
          STDG.LTC_INPATIENT_COPAY AS LTC_INPATIENT_COPAY,
          STDG.LTC_OUTPATIENT_COPAY AS LTC_OUTPATIENT_COPAY,
          STDG.LTC_DOMICILIARY_COPAY AS LTC_DOMICILIARY_COPAY,
          STDG.INPATIENT_PER_DIEM AS INPATIENT_PER_DIEM,
          STDG.MEDICATION_COPAY AS MEDICATION_COPAY,
          STDG.MEDICATION_COPAY_ANNUAL_CAP AS MEDICATION_COPAY_ANNUAL_CAP,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INCOMETHRESHOLD STDG, STD_INCOMETHRESHOLDHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INCOMETHRESHOLD STDG,
                         STD_INCOMETHRESHOLDHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INCOME_THRESHOLD FOR EEUSR.INCOME_THRESHOLD;


GRANT SELECT ON EEUSR.INCOME_THRESHOLD TO EE_V_R;
DROP VIEW EEUSR.INCOME_TEST_TYPE;

/* Formatted on 10/20/2015 1:53:30 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INCOME_TEST_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INCOMETESTTYPE STDG, STD_INCOMETESTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INCOMETESTTYPE STDG,
                         STD_INCOMETESTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INCOME_TEST_TYPE FOR EEUSR.INCOME_TEST_TYPE;


GRANT SELECT ON EEUSR.INCOME_TEST_TYPE TO EE_V_R;
DROP VIEW EEUSR.INCOME_TEST_SRC_TYPE;

/* Formatted on 10/20/2015 1:53:33 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.INCOME_TEST_SRC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INCOMETESTSOURCE STDG, STD_INCOMETESTSOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INCOMETESTSOURCE STDG,
                         STD_INCOMETESTSOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM INCOME_TEST_SRC_TYPE FOR EEUSR.INCOME_TEST_SRC_TYPE;


GRANT SELECT ON EEUSR.INCOME_TEST_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.HLTH_BENEFIT_PLAN_TYPE;

/* Formatted on 10/20/2015 1:53:36 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.HLTH_BENEFIT_PLAN_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   VERSION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT S.ID,
          S.CODE,
          S.NAME AS description,
          S.DESCRIPTION AS name,
          S.VERSION AS VERSION,
          S.CREATED AS RECORD_CREATED_DATE,
          S.UPDATED AS RECORD_MODIFIED_DATE,
          S.CREATEDBY AS RECORD_CREATED_BY,
          S.UPDATEDBY AS RECORD_MODIFIED_BY,
          H.ISACTIVE AS ISACTIVE,
          H.EXPIRATIONDATE AS INACTIVE_DATE
     FROM ADRREF.STD_HLTHBENEFITPLANTYPE S,
          ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY H
    WHERE     S.ID = H.OWNER_ID
          AND H.EXPIRATIONDATE =
                 (SELECT MAX (H.EXPIRATIONDATE)
                    FROM ADRREF.STD_HLTHBENEFITPLANTYPE S2,
                         ADRREF.STD_HLTHBENEFITPLANTYPEHISTORY H2
                   WHERE H2.OWNER_ID = S2.ID);


CREATE OR REPLACE PUBLIC SYNONYM HLTH_BENEFIT_PLAN_TYPE FOR EEUSR.HLTH_BENEFIT_PLAN_TYPE;


GRANT SELECT ON EEUSR.HLTH_BENEFIT_PLAN_TYPE TO EE_V_R;
DROP VIEW EEUSR.HL7_MESSAGE_STATUS_TYPE;

/* Formatted on 10/20/2015 1:53:39 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.HL7_MESSAGE_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_MESSAGESTATUS STDG, STD_MESSAGESTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_MESSAGESTATUS STDG,
                         STD_MESSAGESTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM HL7_MESSAGE_STATUS_TYPE FOR EEUSR.HL7_MESSAGE_STATUS_TYPE;


GRANT SELECT ON EEUSR.HL7_MESSAGE_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.GMT_INCOME_THRESHOLD;

/* Formatted on 10/20/2015 1:53:42 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.GMT_INCOME_THRESHOLD
(
   ID,
   GMT_YEAR,
   COUNTY_CODE,
   MSA_CODE,
   GMT_THRESHOLD_0_DEP,
   GMT_THRESHOLD_1_DEP,
   GMT_THRESHOLD_2_DEP,
   GMT_THRESHOLD_3_DEP,
   GMT_THRESHOLD_4_DEP,
   GMT_THRESHOLD_5_DEP,
   GMT_THRESHOLD_6_DEP,
   GMT_THRESHOLD_7_DEP,
   ISACTIVE,
   INACTIVE_DATE,
   RECORD_CREATED_BY,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_BY,
   RECORD_MODIFIED_DATE
)
AS
   SELECT STDG.ID,
          STDG.EFFECTIVEYEAR AS GMT_YEAR,
          STDG.FIPS AS county_code,
          STDG.MSA AS msa_code,
          STDG.TRHD1 AS GMT_THRESHOLD_0_DEP,
          STDG.TRHD2 AS GMT_THRESHOLD_1_DEP,
          STDG.TRHD3 AS GMT_THRESHOLD_2_DEP,
          STDG.TRHD4 AS GMT_THRESHOLD_3_DEP,
          STDG.TRHD5 AS GMT_THRESHOLD_4_DEP,
          STDG.TRHD6 AS GMT_THRESHOLD_5_DEP,
          STDG.TRHD7 AS GMT_THRESHOLD_6_DEP,
          STDG.TRHD8 AS GMT_THRESHOLD_7_DEP,
          NULL AS ISACTIVE,
          NULL AS INACTIVE_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDG.UPDATED AS RECORD_MODIFIED_DATE
     FROM STD_GMTTHRESHOLDS STDG;


CREATE OR REPLACE PUBLIC SYNONYM GMT_INCOME_THRESHOLD FOR EEUSR.GMT_INCOME_THRESHOLD;


GRANT SELECT ON EEUSR.GMT_INCOME_THRESHOLD TO EE_V_R;
DROP VIEW EEUSR.FIN_STMT_MAPPING_TYPE;

/* Formatted on 10/20/2015 1:53:45 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FIN_STMT_MAPPING_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_FINANCIALMAPPING STDG, STD_FINANCIALMAPPINGHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_FINANCIALMAPPING STDG,
                         STD_FINANCIALMAPPINGHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FIN_STMT_MAPPING_TYPE FOR EEUSR.FIN_STMT_MAPPING_TYPE;


GRANT SELECT ON EEUSR.FIN_STMT_MAPPING_TYPE TO EE_V_R;
DROP VIEW EEUSR.FINANCIAL_INCOME_TYPE;

/* Formatted on 10/20/2015 1:53:48 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FINANCIAL_INCOME_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_INCOMETYPE STDG, STD_INCOMETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_INCOMETYPE STDG, STD_INCOMETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_INCOME_TYPE FOR EEUSR.FINANCIAL_INCOME_TYPE;


GRANT SELECT ON EEUSR.FINANCIAL_INCOME_TYPE TO EE_V_R;
DROP VIEW EEUSR.FINANCIAL_EXPENSE_TYPE;

/* Formatted on 10/20/2015 1:53:51 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FINANCIAL_EXPENSE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EXPENSETYPE STDG, STD_EXPENSETYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EXPENSETYPE STDG, STD_EXPENSETYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_EXPENSE_TYPE FOR EEUSR.FINANCIAL_EXPENSE_TYPE;


GRANT SELECT ON EEUSR.FINANCIAL_EXPENSE_TYPE TO EE_V_R;
DROP VIEW EEUSR.FINANCIAL_ASSET_TYPE;

/* Formatted on 10/20/2015 1:53:54 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FINANCIAL_ASSET_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ASSETTYPE STDG, STD_ASSETTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ASSETTYPE STDG, STD_ASSETTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FINANCIAL_ASSET_TYPE FOR EEUSR.FINANCIAL_ASSET_TYPE;


GRANT SELECT ON EEUSR.FINANCIAL_ASSET_TYPE TO EE_V_R;
DROP VIEW EEUSR.FILIPINO_VET_DOC_TYPE;

/* Formatted on 10/20/2015 1:53:57 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FILIPINO_VET_DOC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_FILIPINOVETERANPROOF STDG, STD_FILIPINOVETPROOFHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_FILIPINOVETERANPROOF STDG,
                         STD_FILIPINOVETPROOFHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FILIPINO_VET_DOC_TYPE FOR EEUSR.FILIPINO_VET_DOC_TYPE;


GRANT SELECT ON EEUSR.FILIPINO_VET_DOC_TYPE TO EE_V_R;
DROP VIEW EEUSR.FEE_BASIS_TREATMENT_TYPE;

/* Formatted on 10/20/2015 1:54:01 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FEE_BASIS_TREATMENT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_FEEBASISTREATMENTCODETYPE STDG, STD_FEEBASISTRTMNTHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_FEEBASISTREATMENTCODETYPE STDG,
                         STD_FEEBASISTRTMNTHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS_TREATMENT_TYPE FOR EEUSR.FEE_BASIS_TREATMENT_TYPE;


GRANT SELECT ON EEUSR.FEE_BASIS_TREATMENT_TYPE TO EE_V_R;
DROP VIEW EEUSR.FEE_BASIS_PROGRAM_TYPE;

/* Formatted on 10/20/2015 1:54:05 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FEE_BASIS_PROGRAM_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_FEEBASISPROGRAM STDG, STD_FEEBASISPRGRMHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_FEEBASISPROGRAM STDG,
                         STD_FEEBASISPRGRMHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FEE_BASIS_PROGRAM_TYPE FOR EEUSR.FEE_BASIS_PROGRAM_TYPE;


GRANT SELECT ON EEUSR.FEE_BASIS_PROGRAM_TYPE TO EE_V_R;
DROP VIEW EEUSR.FEDERAL_AGENCY_TYPE;

/* Formatted on 10/20/2015 1:54:08 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.FEDERAL_AGENCY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_OTHERFEDERALAGENCY STDG, STD_OTHERFEDERALAGENCYHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_OTHERFEDERALAGENCY STDG,
                         STD_OTHERFEDERALAGENCYHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM FEDERAL_AGENCY_TYPE FOR EEUSR.FEDERAL_AGENCY_TYPE;


GRANT SELECT ON EEUSR.FEDERAL_AGENCY_TYPE TO EE_V_R;
DROP VIEW EEUSR.ENROLLMENT_DATA_SRC_TYPE;

/* Formatted on 10/20/2015 1:54:11 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ENROLLMENT_DATA_SRC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ENROLLMENTSOURCE STDG, STD_ENROLLMENTSOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ENROLLMENTSOURCE STDG,
                         STD_ENROLLMENTSOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ENROLLMENT_DATA_SRC_TYPE FOR EEUSR.ENROLLMENT_DATA_SRC_TYPE;


GRANT SELECT ON EEUSR.ENROLLMENT_DATA_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.EMPLOYMENT_STATUS_TYPE;

/* Formatted on 10/20/2015 1:54:14 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.EMPLOYMENT_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EMPLOYMENTSTATUS STDG, STD_EMPLOYMENTSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EMPLOYMENTSTATUS STDG,
                         STD_EMPLOYMENTSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM EMPLOYMENT_STATUS_TYPE FOR EEUSR.EMPLOYMENT_STATUS_TYPE;


GRANT SELECT ON EEUSR.EMPLOYMENT_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.EMAIL_TYPE;

/* Formatted on 10/20/2015 1:54:17 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.EMAIL_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EMAILADDRESSTYPE STDG, STD_EMAILADDRESSTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EMAILADDRESSTYPE STDG,
                         STD_EMAILADDRESSTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM EMAIL_TYPE FOR EEUSR.EMAIL_TYPE;


GRANT SELECT ON EEUSR.EMAIL_TYPE TO EE_V_R;
DROP VIEW EEUSR.EMAIL_CHANGE_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:54:20 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.EMAIL_CHANGE_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EMAILCHANGESOURCE STDG, STD_EMAILCHANGESOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EMAILCHANGESOURCE STDG,
                         STD_EMAILCHANGESOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM EMAIL_CHANGE_SOURCE_TYPE FOR EEUSR.EMAIL_CHANGE_SOURCE_TYPE;


GRANT SELECT ON EEUSR.EMAIL_CHANGE_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.ELIGIBILITY_TYPE;

/* Formatted on 10/20/2015 1:54:25 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ELIGIBILITY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ELIGIBILITYCODE STDG, STD_ELIGIBILITYCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ELIGIBILITYCODE STDG,
                         STD_ELIGIBILITYCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ELIGIBILITY_TYPE FOR EEUSR.ELIGIBILITY_TYPE;


GRANT SELECT ON EEUSR.ELIGIBILITY_TYPE TO EE_V_R;
DROP VIEW EEUSR.ELGBTY_VRFN_SOURCE_TYPE;

/* Formatted on 10/20/2015 1:54:28 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ELGBTY_VRFN_SOURCE_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ELIGIBILITYVRSCTYP STDG, STD_ELIGIBILITYVRSCTYPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ELIGIBILITYVRSCTYP STDG,
                         STD_ELIGIBILITYVRSCTYPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ELGBTY_VRFN_SOURCE_TYPE FOR EEUSR.ELGBTY_VRFN_SOURCE_TYPE;


GRANT SELECT ON EEUSR.ELGBTY_VRFN_SOURCE_TYPE TO EE_V_R;
DROP VIEW EEUSR.ELGBTY_STATUS_TYPE;

/* Formatted on 10/20/2015 1:54:31 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ELGBTY_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ELIGIBILITYSTATUS STDG, STD_ELIGIBILITYSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ELIGIBILITYSTATUS STDG,
                         STD_ELIGIBILITYSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ELGBTY_STATUS_TYPE FOR EEUSR.ELGBTY_STATUS_TYPE;


GRANT SELECT ON EEUSR.ELGBTY_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.EGT_TYPE;

/* Formatted on 10/20/2015 1:54:35 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.EGT_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EGTTYPE STDG, STD_EGTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EGTTYPE STDG, STD_EGTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM EGT_TYPE FOR EEUSR.EGT_TYPE;


GRANT SELECT ON EEUSR.EGT_TYPE TO EE_V_R;
DROP VIEW EEUSR.EGT_STATUS_TYPE;

/* Formatted on 10/20/2015 1:54:38 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.EGT_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EGTPROCESSSTATUS STDG, STD_EGTPROCESSSTATUSHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EGTPROCESSSTATUS STDG,
                         STD_EGTPROCESSSTATUSHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM EGT_STATUS_TYPE FOR EEUSR.EGT_STATUS_TYPE;


GRANT SELECT ON EEUSR.EGT_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.DIAGNOSTIC_EXTREMITY_TYPE;

/* Formatted on 10/20/2015 1:54:42 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.DIAGNOSTIC_EXTREMITY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EXTREMITYCODE STDG, STD_EXTREMITYCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EXTREMITYCODE STDG,
                         STD_EXTREMITYCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM DIAGNOSTIC_EXTREMITY_TYPE FOR EEUSR.DIAGNOSTIC_EXTREMITY_TYPE;


GRANT SELECT ON EEUSR.DIAGNOSTIC_EXTREMITY_TYPE TO EE_V_R;
DROP VIEW EEUSR.DIAGNOSIS_TYPE;

/* Formatted on 10/20/2015 1:54:45 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.DIAGNOSIS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE,
   CODESET_TYPE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE,
          STDG.CODESET_TYPE
     FROM STD_DIAGNOSISCODE STDG, STD_DIAGNOSISCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_DIAGNOSISCODE STDG,
                         STD_DIAGNOSISCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM DIAGNOSIS_TYPE FOR EEUSR.DIAGNOSIS_TYPE;


GRANT SELECT ON EEUSR.DIAGNOSIS_TYPE TO EE_V_R;
DROP VIEW EEUSR.DEATH_NOTIFICATION_SRC_TYPE;

/* Formatted on 10/20/2015 1:54:48 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.DEATH_NOTIFICATION_SRC_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_DEATHNOTIFICATION STDG, STD_DEATHNOTIFICATIONHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_DEATHNOTIFICATION STDG,
                         STD_DEATHNOTIFICATIONHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM DEATH_NOTIFICATION_SRC_TYPE FOR EEUSR.DEATH_NOTIFICATION_SRC_TYPE;


GRANT SELECT ON EEUSR.DEATH_NOTIFICATION_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.CONFIDENTIAL_ADDR_TYPE;

/* Formatted on 10/20/2015 1:54:51 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CONFIDENTIAL_ADDR_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_CONFIDENTIALADDRESSCAT STDG, STD_CONFADDRCATHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_CONFIDENTIALADDRESSCAT STDG,
                         STD_CONFADDRCATHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM CONFIDENTIAL_ADDR_TYPE FOR EEUSR.CONFIDENTIAL_ADDR_TYPE;


GRANT SELECT ON EEUSR.CONFIDENTIAL_ADDR_TYPE TO EE_V_R;
DROP VIEW EEUSR.CONDITION_TYPE;

/* Formatted on 10/20/2015 1:54:54 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CONDITION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_CONDITIONCODE STDG, STD_CONDITIONCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_CONDITIONCODE STDG,
                         STD_CONDITIONCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM CONDITION_TYPE FOR EEUSR.CONDITION_TYPE;


GRANT SELECT ON EEUSR.CONDITION_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_MAILING_TRIGGER_TYPE;

/* Formatted on 10/20/2015 1:54:57 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_MAILING_TRIGGER_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMMMLTRIGGERTYPE STDG, STD_COMMMLTRIGGERTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMMMLTRIGGERTYPE STDG,
                         STD_COMMMLTRIGGERTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_MAILING_TRIGGER_TYPE FOR EEUSR.COM_MAILING_TRIGGER_TYPE;


GRANT SELECT ON EEUSR.COM_MAILING_TRIGGER_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_MAILING_STATUS_TYPE;

/* Formatted on 10/20/2015 1:55:01 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_MAILING_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMMMAILINGSTTYPE STDG, STD_COMMMAILINGSTTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMMMAILINGSTTYPE STDG,
                         STD_COMMMAILINGSTTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_MAILING_STATUS_TYPE FOR EEUSR.COM_MAILING_STATUS_TYPE;


GRANT SELECT ON EEUSR.COM_MAILING_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_LETTER_TYPE;

/* Formatted on 10/20/2015 1:55:04 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_LETTER_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMMLETTERTYPE STDG, STD_COMMLETTERTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMMLETTERTYPE STDG,
                         STD_COMMLETTERTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_LETTER_TYPE FOR EEUSR.COM_LETTER_TYPE;


GRANT SELECT ON EEUSR.COM_LETTER_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_LETTER_GENERATED_TYPE;

/* Formatted on 10/20/2015 1:55:06 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_LETTER_GENERATED_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMMLETTERGENTYPE STDG, STD_COMMLETTERGENTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMMLETTERGENTYPE STDG,
                         STD_COMMLETTERGENTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_LETTER_GENERATED_TYPE FOR EEUSR.COM_LETTER_GENERATED_TYPE;


GRANT SELECT ON EEUSR.COM_LETTER_GENERATED_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_AAC_REJECT_REASON_TYPE;

/* Formatted on 10/20/2015 1:55:11 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_AAC_REJECT_REASON_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMREJECTREASONTYPE STDG, STD_COMREJECTREASONTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMREJECTREASONTYPE STDG,
                         STD_COMREJECTREASONTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_AAC_REJECT_REASON_TYPE FOR EEUSR.COM_AAC_REJECT_REASON_TYPE;


GRANT SELECT ON EEUSR.COM_AAC_REJECT_REASON_TYPE TO EE_V_R;
DROP VIEW EEUSR.COM_AAC_ERROR_TYPE;

/* Formatted on 10/20/2015 1:55:15 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COM_AAC_ERROR_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COMMERRORTYPE STDG, STD_COMMERRORTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COMMERRORTYPE STDG,
                         STD_COMMERRORTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COM_AAC_ERROR_TYPE FOR EEUSR.COM_AAC_ERROR_TYPE;


GRANT SELECT ON EEUSR.COM_AAC_ERROR_TYPE TO EE_V_R;
DROP VIEW EEUSR.COLLECTION_METHOD_TYPE;

/* Formatted on 10/20/2015 1:55:18 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.COLLECTION_METHOD_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.HL7CODE AS CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_COLLECTIONMETHOD STDG, STD_COLLECTIONHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_COLLECTIONMETHOD STDG,
                         STD_COLLECTIONHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM COLLECTION_METHOD_TYPE FOR EEUSR.COLLECTION_METHOD_TYPE;


GRANT SELECT ON EEUSR.COLLECTION_METHOD_TYPE TO EE_V_R;
DROP VIEW EEUSR.CL_VERIFICATION_TYPE;

/* Formatted on 10/20/2015 1:55:22 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CL_VERIFICATION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   VERSION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT S.ID,
          S.CODE,
          S.NAME AS description,
          S.DESCRIPTION AS name,
          S.VERSION AS VERSION,
          S.CREATED AS RECORD_CREATED_DATE,
          S.UPDATED AS RECORD_MODIFIED_DATE,
          S.CREATEDBY AS RECORD_CREATED_BY,
          S.UPDATEDBY AS RECORD_MODIFIED_BY,
          H.ISACTIVE AS ISACTIVE,
          H.EXPIRATIONDATE AS INACTIVE_DATE
     FROM ADRREF.STD_CLVERIFICATIONTYPE S,
          ADRREF.STD_CLVERIFICATIONTYPEHISTORY H
    WHERE     S.ID = H.OWNER_ID
          AND H.EXPIRATIONDATE =
                 (SELECT MAX (H.EXPIRATIONDATE)
                    FROM ADRREF.STD_CLVERIFICATIONTYPE S2,
                         ADRREF.STD_CLVERIFICATIONTYPEHISTORY H2
                   WHERE H2.OWNER_ID = S2.ID);


CREATE OR REPLACE PUBLIC SYNONYM CL_VERIFICATION_TYPE FOR EEUSR.CL_VERIFICATION_TYPE;


GRANT SELECT ON EEUSR.CL_VERIFICATION_TYPE TO EE_V_R;
DROP VIEW EEUSR.CL_SOURCE_OF_CHANGE;

/* Formatted on 10/20/2015 1:55:25 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CL_SOURCE_OF_CHANGE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   VERSION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT S.ID,
          S.CODE,
          S.NAME AS description,
          S.DESCRIPTION AS name,
          S.VERSION AS VERSION,
          S.CREATED AS RECORD_CREATED_DATE,
          S.UPDATED AS RECORD_MODIFIED_DATE,
          S.CREATEDBY AS RECORD_CREATED_BY,
          S.UPDATEDBY AS RECORD_MODIFIED_BY,
          H.ISACTIVE AS ISACTIVE,
          H.EXPIRATIONDATE AS INACTIVE_DATE
     FROM ADRREF.STD_CLSOURCEOFCHANGE S, ADRREF.STD_CLSOURCEOFCHANGEHISTORY H
    WHERE     S.ID = H.OWNER_ID
          AND H.EXPIRATIONDATE =
                 (SELECT MAX (H.EXPIRATIONDATE)
                    FROM ADRREF.STD_CLSOURCEOFCHANGE S2,
                         ADRREF.STD_CLSOURCEOFCHANGEHISTORY H2
                   WHERE H2.OWNER_ID = S2.ID);


CREATE OR REPLACE PUBLIC SYNONYM CL_SOURCE_OF_CHANGE FOR EEUSR.CL_SOURCE_OF_CHANGE;


GRANT SELECT ON EEUSR.CL_SOURCE_OF_CHANGE TO EE_V_R;
DROP VIEW EEUSR.CAT_DSBLTY_EVAL_MTHD_TYPE;

/* Formatted on 10/20/2015 1:55:28 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CAT_DSBLTY_EVAL_MTHD_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_EVALUATIONMETHOD STDG, STD_EVALUATIONMETHODHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_EVALUATIONMETHOD STDG,
                         STD_EVALUATIONMETHODHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM CAT_DSBLTY_EVAL_MTHD_TYPE FOR EEUSR.CAT_DSBLTY_EVAL_MTHD_TYPE;


GRANT SELECT ON EEUSR.CAT_DSBLTY_EVAL_MTHD_TYPE TO EE_V_R;
DROP VIEW EEUSR.CANCEL_DECLINE_STATUS_TYPE;

/* Formatted on 10/20/2015 1:55:34 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CANCEL_DECLINE_STATUS_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_CANCELDECLINESTTYP STDG, STD_CANCELDECLINESTTYPHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_CANCELDECLINESTTYP STDG,
                         STD_CANCELDECLINESTTYPHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM CANCEL_DECLINE_STATUS_TYPE FOR EEUSR.CANCEL_DECLINE_STATUS_TYPE;


GRANT SELECT ON EEUSR.CANCEL_DECLINE_STATUS_TYPE TO EE_V_R;
DROP VIEW EEUSR.CANCEL_DECLINE_REASON_TYPE;

/* Formatted on 10/20/2015 1:55:37 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.CANCEL_DECLINE_REASON_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_CANCELDECLINEREASON STDG, STD_CANCELDECLINEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_CANCELDECLINEREASON STDG,
                         STD_CANCELDECLINEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM CANCEL_DECLINE_REASON_TYPE FOR EEUSR.CANCEL_DECLINE_REASON_TYPE;


GRANT SELECT ON EEUSR.CANCEL_DECLINE_REASON_TYPE TO EE_V_R;
DROP VIEW EEUSR.APP_PARAMETER_UNIT;

/* Formatted on 10/20/2015 1:55:42 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.APP_PARAMETER_UNIT
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_APPPARAMETERUNIT STDG, STD_APPPARAMETERUNITHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_APPPARAMETERUNIT STDG,
                         STD_APPPARAMETERUNITHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM APP_PARAMETER_UNIT FOR EEUSR.APP_PARAMETER_UNIT;


GRANT SELECT ON EEUSR.APP_PARAMETER_UNIT TO EE_V_R;
DROP VIEW EEUSR.APP_PARAMETER_TYPE;

/* Formatted on 10/20/2015 1:55:45 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.APP_PARAMETER_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_APPPARAMETERTYPE STDG, STD_APPPARAMETERTYPEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_APPPARAMETERTYPE STDG,
                         STD_APPPARAMETERTYPEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM APP_PARAMETER_TYPE FOR EEUSR.APP_PARAMETER_TYPE;


GRANT SELECT ON EEUSR.APP_PARAMETER_TYPE TO EE_V_R;
DROP VIEW EEUSR.ALLIED_COUNTRY_TYPE;

/* Formatted on 10/20/2015 1:55:48 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ALLIED_COUNTRY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ALLIEDCOUNTRY STDG, STD_ALLIEDCOUNTRYHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ALLIEDCOUNTRY STDG,
                         STD_ALLIEDCOUNTRYHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ALLIED_COUNTRY_TYPE FOR EEUSR.ALLIED_COUNTRY_TYPE;


GRANT SELECT ON EEUSR.ALLIED_COUNTRY_TYPE TO EE_V_R;
DROP VIEW EEUSR.AGENT_ORANGE_LOCATION_TYPE;

/* Formatted on 10/20/2015 1:55:52 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.AGENT_ORANGE_LOCATION_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_AGENTORANGELOCATION STDG, STD_AGENTORANGELOCNHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_AGENTORANGELOCATION STDG,
                         STD_AGENTORANGELOCNHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM AGENT_ORANGE_LOCATION_TYPE FOR EEUSR.AGENT_ORANGE_LOCATION_TYPE;


GRANT SELECT ON EEUSR.AGENT_ORANGE_LOCATION_TYPE TO EE_V_R;
DROP VIEW EEUSR.AFFECTED_EXTREMITY_TYPE;

/* Formatted on 10/20/2015 1:55:55 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.AFFECTED_EXTREMITY_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_AffectedExtremity STDG, STD_AffectedExtremityHistory STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_AffectedExtremity STDG,
                         STD_AffectedExtremityHistory STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM AFFECTED_EXTREMITY_TYPE FOR EEUSR.AFFECTED_EXTREMITY_TYPE;


GRANT SELECT ON EEUSR.AFFECTED_EXTREMITY_TYPE TO EE_V_R;
DROP VIEW EEUSR.ADDRESS_INVALID_TYPE;

/* Formatted on 10/20/2015 1:55:59 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ADDRESS_INVALID_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ADDRESSDELIVERYFAILURECODE STDG,
          STD_ADRSDLVRYFLRCDHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ADDRESSDELIVERYFAILURECODE STDG,
                         STD_ADRSDLVRYFLRCDHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ADDRESS_INVALID_TYPE FOR EEUSR.ADDRESS_INVALID_TYPE;


GRANT SELECT ON EEUSR.ADDRESS_INVALID_TYPE TO EE_V_R;
DROP VIEW EEUSR.ADDRESS_CHANGE_SRC_TYPE;

/* Formatted on 10/20/2015 1:56:03 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ADDRESS_CHANGE_SRC_TYPE
(
   ID,
   CODE,
   NAME,
   DESCRIPTION,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS NAME,
          STDG.DESCRIPTION AS DESCRIPTION,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_ADDRESSCHANGESOURCE STDG, STD_ADDRESSCHANGESOURCEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_ADDRESSCHANGESOURCE STDG,
                         STD_ADDRESSCHANGESOURCEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ADDRESS_CHANGE_SRC_TYPE FOR EEUSR.ADDRESS_CHANGE_SRC_TYPE;


GRANT SELECT ON EEUSR.ADDRESS_CHANGE_SRC_TYPE TO EE_V_R;
DROP VIEW EEUSR.ACK_TYPE;

/* Formatted on 10/20/2015 1:56:07 PM (QP5 v5.227.12220.39754) */
CREATE OR REPLACE FORCE VIEW EEUSR.ACK_TYPE
(
   ID,
   CODE,
   DESCRIPTION,
   NAME,
   RECORD_CREATED_DATE,
   RECORD_MODIFIED_DATE,
   RECORD_CREATED_BY,
   RECORD_MODIFIED_BY,
   ISACTIVE,
   INACTIVE_DATE
)
AS
   SELECT STDG.ID,
          STDG.CODE,
          STDG.NAME AS description,
          STDG.DESCRIPTION AS name,
          STDG.CREATED AS RECORD_CREATED_DATE,
          STDG.UPDATED AS RECORD_MODIFIED_DATE,
          STDG.CREATEDBY AS RECORD_CREATED_BY,
          STDG.UPDATEDBY AS RECORD_MODIFIED_BY,
          STDGH.ISACTIVE AS ISACTIVE,
          STDGH.EXPIRATIONDATE AS INACTIVE_DATE
     FROM STD_HL7ACKNOWLEDGEMENTCODE STDG, STD_HL7ACKCODEHISTORY STDGH
    WHERE     STDG.ID = STDGH.OWNER_ID
          AND STDGH.EXPIRATIONDATE =
                 (SELECT MAX (STDGH.EXPIRATIONDATE)
                    FROM STD_HL7ACKNOWLEDGEMENTCODE STDG,
                         STD_HL7ACKCODEHISTORY STDGH
                   WHERE STDGH.OWNER_ID = STDG.ID);


CREATE OR REPLACE PUBLIC SYNONYM ACK_TYPE FOR EEUSR.ACK_TYPE;


GRANT SELECT ON EEUSR.ACK_TYPE TO EE_V_R;
